#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Truchet experimentationsMod01.fsh   by  ManuManu
//https://www.shadertoy.com/view/3s2fR1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float hash21(vec2 p)
{
    float v = fract(sin( p.x*1234.68 + p.y * 98765.543)*753.159);
    return v;
}

vec3 palette( float t, vec3 a, vec3 b, vec3 c, vec3 d )
{
    return a + b * cos( 2.*3.14159 * ( c * t + d) );
}

// Different tries with palettes :
vec3 MyPalette1( float t )
{
    return palette( t, vec3(.8, .5, .4), vec3(.2,.4,.2), vec3( .5), vec3( 0., .25, .25));
}
vec3 MyPalette2( float t )
{
    return palette( t, vec3(.5, .5, 5), vec3(.5, .5, .5), vec3( 1., 0.7,0.4), vec3( 0., .15, .2));
}
vec3 MyPalette3( float t )
{
    return palette( t, vec3(.5), vec3(.5), vec3( 1.), vec3( 0.3, .2, .2));
}
vec3 MyPalette4( float t )
{
    return palette( t, vec3(.5), vec3(.5), vec3( 1.,1.,0.5), vec3( 0.8, .9, .3));
}
vec3 MyPalette5( float t )
{
    return palette( t, vec3(.8, .5, .4), vec3(.2), vec3( .5,.5,0.5), vec3( 0., .9, .3));
}


vec3 MyPalette( float t )
{
    return MyPalette3(t);
}

float full_width = 0.09;
float fade_width = 0.1;

vec3 insideBoxDraw2( vec2 uv )
{
    vec3 col;
    float d = min( abs(uv.x), abs(uv.y));
    float val = smoothstep( fade_width, 0.,  d - full_width);
    col = vec3(val);
    return col;
}
vec3 insideBoxDraw3( vec2 uv )
{
    vec3 col;
    float d = abs(abs(uv.x + uv.y) -.5);
    float val = smoothstep( fade_width, 0.,  d - full_width);
    col = vec3(val);
    return col;
}

vec3 circle( vec2 uv, vec2 center, float rad, float width, vec3 color )
{
    float d = length(uv - center );
    float val = smoothstep(  fade_width, 0., abs( d-rad) - full_width );
    return val * color;
}

vec3 insideBoxDraw( vec2 uv )
{
    vec3 col = vec3(0.);
    
    vec2 center = vec2(.5,.5);
    vec2 center2 = vec2(-.5,-.5);
    
    col  = circle( uv, center, .5, 0.05, vec3( 1.,1.,1.));
    col += circle( uv, center2, .5, 0.05, vec3( 1.,1.,1.));
    return col;
}

float truchet(vec2 p )
{
    float returnVal = 0.;
    
    vec2 boxCoord = fract(p)-.5;
    vec2 id = floor(p);
    
    
    //col = vec3( 1.-length(boxCoord) );
    
    float rnd = hash21( id );
    if ( rnd < .5)
        boxCoord.x = -boxCoord.x;
    
    float rnd2 = mod(rnd, .5 ) * 2.; 
    if ( rnd2 < .33)
	    returnVal = insideBoxDraw2(boxCoord).x;
    else
        if ( rnd2 < .66)
			returnVal = insideBoxDraw(boxCoord).x;
        else
            returnVal = insideBoxDraw3(boxCoord).x;
        
     
    return returnVal;    
    /*
    if ( boxCoord.x > 0.48 || boxCoord.y > 0.48 )
        col = vec3(1., 0.,0.);
    //*/
}

mat2 rot( float a )
{
    float c = cos(a);
    float s = sin(a);
    return mat2( c, s, -s, c);
}
vec2 moveUV( vec2 uv, float angle, float zoom, vec2 dep )
{
    return rot( angle ) * ( ( uv * zoom) + dep );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy * 2. - 1.;
	uv.x *= iResolution.x/iResolution.y;

    vec2 realUv = uv;
	vec3 col = length(uv*.3) *vec3(0.3,0.3,0.8);

    // general camera move :
    uv = moveUV( uv, sin(iTime*.2), 1.1+.2*sin(iTime*.51), vec2(cos(iTime*.1), sin(iTime*.07)));
    
    float nbLayers = 10.;
    for( float i = 0.; i < nbLayers; i+= 1.)
    {
        vec2 coord = moveUV( uv, iTime/(.3*i+1.), (nbLayers-i)*2., (nbLayers-i)*vec2(cos(iTime*5./(i+1.)), sin(iTime*3./(i+1.))) );
        float truchetVal = truchet(coord);
        
        
        float timeFactorPal = .5;
        vec3 paletteColor1= mix( MyPalette1( length(coord )*2.), MyPalette5( length(coord )*.5), .5+.5*sin(iTime*timeFactorPal)) ;
        vec3 paletteColor2 = mix( MyPalette1( length(coord )*2.), MyPalette3( length(coord )*3.), .5+.5*sin(iTime*timeFactorPal)) ;
        
        //vec3 paletteColor = mix( paletteColor1, paletteColor2, i/nbLayers);
        vec3 paletteColor = paletteColor1;
    
        vec3 layerCol = paletteColor * ( i) / nbLayers;
        col = mix( col,  layerCol, truchetVal);
    }
    
    // Output to screen
    //vignetting :
    col*=smoothstep(2.5,1.,length(realUv));
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

